<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Tiny_Framework
 * @since Tiny Framework 1.0
 */

get_header(); ?>

	<div id="primary" class="content-area">

		<?php tha_content_before(); // custom action hook ?>

		<main id="main" class="site-main" role="main" itemprop="mainContentOfPage">

			<?php tha_content_top(); // custom action hook ?>

			<?php tha_entry_before(); // custom action hook ?>

			<section class="error-404 not-found">

				<?php tha_entry_top(); // custom action hook ?>

				<header class="page-header">
					<h1 class="page-title"><?php esc_html_e( 'This is somewhat embarrassing, isn&rsquo;t it?', 'tinyframework' ); ?></h1>
				</header><!-- .page-header -->

				<div class="page-content">

					<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'tinyframework' ); ?></p>

					<?php get_search_form(); ?>

					<?php the_widget( 'WP_Widget_Recent_Posts' ); ?>

					<?php
						// translators: %1$s: smiley
						$archive_content = '<p>' . sprintf( esc_html__( 'Try looking in the monthly archives. %1$s', 'tinyframework' ), convert_smilies( ':)' ) ) . '</p>';
						the_widget( 'WP_Widget_Archives', 'dropdown=1', "after_title=</h2>$archive_content" );
					?>

					<?php the_widget( 'WP_Widget_Tag_Cloud' ); ?>

				</div><!-- .page-content -->

				<?php tha_entry_bottom(); // custom action hook ?>

			</section><!-- .error-404 -->

			<?php tha_entry_after(); // custom action hook ?>
			
			<?php tha_content_bottom(); // custom action hook ?>

		</main><!-- .site-main -->

		<?php tha_content_after(); // custom action hook ?>

	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>